<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de la compra</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>

    <h1>Lista de la compra</h1>

    <?php
    /* COMPRUEBO QUE EXISTEN LAS COOKIES O LAS INICIO A CERO -INICIO */

    if (isset($_COOKIE['articulos'])) {
        $articulos = unserialize($_COOKIE['articulos']);
        $cantidad = count($articulos);
    } else {
        $articulos = [];
        $cantidad = 0;
        setcookie("articulos", serialize($articulos), time() + (365 * 24 * 60 * 60), "/");
    }

    if (isset($_COOKIE['tiendas'])) {
        $tiendas = unserialize($_COOKIE['tiendas']);
        $cantidadtiendas = count($tiendas);
    } else {
        $tiendas = [];
        $cantidadtiendas = 0;
        setcookie("tiendas", serialize($tiendas), time() + (365 * 24 * 60 * 60), "/");
    }
    /* COMPRUEBO QUE EXISTEN LAS COOKIES O LAS INICIO A CERO -FIN */

    /* FORMULARIO DE ENTRADA DE ARTICULOS Y SELECCION DE TIENDA -INICIO */
    ?>
    <form action="guardar.php" method="post" id="introducirdatos">
        <input type="text" name="articulonuevo" maxlength="30" required autofocus>
        <?php
        if ($cantidadtiendas == 0) {
            header("Location: tiendas.php?error=0");
            exit();
        } else {
        ?>
            <select name="tienda">
                <?php
                echo '<option value="">--TIENDA--</option>';
                foreach ($tiendas as $key => $valor) {
                    echo '<option value="' . $key . '">' . $valor . '</option>';
                }
                ?>
            </select>

        <?php
        }
        for ($i = 0; $i < $cantidad; $i++) {
            echo '<input type="hidden" name="articulo' . $i . '" value="' . $articulos[$i][0] . '">';
            echo '<input type="hidden" name="tienda' . $i . '" value="' . $articulos[$i][1] . '">';
        }
        ?>
        <input type="submit" value="Agregar a la lista">
    </form>
    <a href="tiendas.php">Gestion de Tiendas</a>
    <br>
    <a href="listatiendas.php">Ordenar por Tiendas</a>
    <ul>
        <?php
        /* FORMULARIO DE ENTRADA DE ARTICULOS Y SELECCION DE TIENDA -FIN */

        /* LISTADO DE ARTICULOS Y BOTON EN FORMULARIO PARA BORRAR -INICIO */
        for ($i = 0; $i < $cantidad; $i++) {
            echo "<li><div><p>" . $articulos[$i][0] . '</p></div><div><p> - ' . $tiendas[$articulos[$i][1]] . '</p></div><form action="guardar.php" method="post">';
            echo '<input type="hidden" name="borrararticulo" value="' . $i . '">';
            echo '<input type="submit" value="Borrar"></form></li>';
        }
        /* LISTADO DE ARTICULOS Y BOTON EN FORMULARIO PARA BORRAR -INICIO */
        ?>
    </ul>
</body>

</html>