<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de la compra</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <?php
    /* RECUPERO EL NOMBRE DEL USUARIO LOGUEADO -INICIO */
    if (isset($_COOKIE['usuario'])) {
        $usuario = base64_decode($_COOKIE['usuario']);
    } else {
        $usuario = base64_decode($_GET['usuariocorrecto']);
    }
    /* RECUPERO EL NOMBRE DEL USUARIO LOGUEADO -FIN */
    ?>
    <h1>Lista de la compra de <?php echo $usuario; ?> <a target="_blank" class="ocultar" href="lista_<?php echo $usuario; ?>.txt">Lista .txt</a></h1>
    <a href="cerrarsesion.php">Cerrar Sesion</a>

    <?php
    /* COMPRUEBO QUE EXISTEN LOS .TXT O LOS INICIO A CERO -INICIO */
    if (file_exists("lista_" . $usuario . ".txt")) {
        $articulos = unserialize(file_get_contents("lista_" . $usuario . ".txt"));
        if ($articulos == null) {
            $articulos = [];
            $cantidad = 0;
        } else {
            $cantidad = count($articulos);
        }
    } else {
        $articulos = [];
        $cantidad = 0;
    }
    if (file_exists("tienda_" . $usuario . ".txt")) {
        $tiendas = unserialize(file_get_contents("tienda_" . $usuario . ".txt"));
        if ($tiendas == null) {
            $tiendas = [];
            $cantidadtiendas = 0;
        } else {
            $cantidadtiendas = count($tiendas);
        }
    } else {
        $tiendas = [];
        $cantidadtiendas = 0;
    }
    /* COMPRUEBO QUE EXISTEN LOS .TXT O LOS INICIO A CERO -FIN */

    /* FORMULARIO DE ENTRADA DE ARTICULOS Y SELECCION DE TIENDA -INICIO */
    ?>
    <form action="guardar.php" method="post" id="introducirdatos">
        <input type="text" name="articulonuevo" maxlength="30" required autofocus>
        <?php
        if ($cantidadtiendas == 0) {
            header("Location: tiendas.php?error=0&usuariocorrecto=" . base64_encode($usuario) . "");
            exit();
        } else {
        ?>
            <select name="tienda">
                <?php
                foreach ($tiendas as $key => $valor) {
                    echo '<option value="' . $key . '">' . $valor . '</option>';
                }
                ?>
            </select>

        <?php
        }
        for ($i = 0; $i < $cantidad; $i++) {
            echo '<input type="hidden" name="articulo' . $i . '" value="' . $articulos[$i][0] . '">';
            echo '<input type="hidden" name="tienda' . $i . '" value="' . $articulos[$i][1] . '">';
        }
        echo '<input type="hidden" name="cantidad" value="' . count($articulos) . '">';
        echo '<input type="hidden" name="cantidadtiendas" value="' . count($tiendas) . '">';
        echo '<input type="hidden" name="usuario" value="' . $usuario . '">';
        ?>
        <input type="submit" value="Agregar a la lista">
    </form>
    <a href="tiendas.php?candidadtiendas=<?php echo $cantidadtiendas; ?>&&usuariocorrecto=<?php echo base64_encode($usuario); ?>">Gestion de Tiendas</a>
    <br>
    <a href="listatiendas.php?usuariocorrecto=<?php echo base64_encode($usuario); ?>">Ordenar por Tiendas</a>
    <ul>
        <?php
        /* FORMULARIO DE ENTRADA DE ARTICULOS Y SELECCION DE TIENDA -FIN */

        /* LISTADO DE ARTICULOS Y BOTON EN FORMULARIO PARA BORRAR -INICIO */
        for ($i = 0; $i < $cantidad; $i++) {
            echo "<li><div><p>" . $articulos[$i][0] . '</p></div><div><p> - ' . $tiendas[$articulos[$i][1]] . '</p></div><form action="guardar.php" method="post">';
            echo '<input type="hidden" name="borrararticulo" value="' . $i . '">';
            for ($cont = 0; $cont < $cantidad; $cont++) {
                echo '<input type="hidden" name="articulo' . $cont . '" value="' . $articulos[$cont][0] . '">';
                echo '<input type="hidden" name="tienda' . $cont . '" value="' . $articulos[$cont][1] . '">';
            }
            echo '<input type="hidden" name="cantidad" value="' . $cantidad . '">';
            echo '<input type="hidden" name="usuario" value="' . $usuario . '">';
            echo '<input type="submit" value="Borrar"></form></li>';
        }
        /* LISTADO DE ARTICULOS Y BOTON EN FORMULARIO PARA BORRAR -INICIO */
        ?>
    </ul>
</body>

</html>