<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de la compra</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <?php
    /* RECUPERO EL NOMBRE DEL USUARIO LOGUEADO -INICIO */
    if (isset($_COOKIE['usuario'])) {
        $usuario = base64_decode($_COOKIE['usuario']);
    } else {
        $usuario = base64_decode($_GET['usuariocorrecto']);
    }
    /* RECUPERO EL NOMBRE DEL USUARIO LOGUEADO -FIN */
    ?>
    <h1>Tiendas de <?php echo $usuario; ?> <a target="_blank" class="ocultar" href="tienda_<?php echo $usuario; ?>.txt">Tiendas.txt</a></h1>
    <a href="cerrarsesion.php">Cerrar Sesion</a>

    <?php
    if (isset($_GET['error'])) {
        echo "<h2>DEBE EXISTIR AL MENOS 1 TIENDA";
    }

    if (file_exists("tienda_" . $usuario . ".txt")) {
        $tiendas = unserialize(file_get_contents("tienda_" . $usuario . ".txt"));
        if ($tiendas == null) {
            $tiendas = [];
            $cantidadtiendas = 0;
        } else {
            $cantidadtiendas = count($tiendas);
        }
    } else {
        $tiendas = [];
        $cantidadtiendas = 0;
    }

    $nuevo = 0;
    if (isset($_POST['nuevatienda'])) {
        $tiendas[$cantidadtiendas] = $_POST['nuevatienda'];
        $nuevo = 1;
    }
    ?>

    <a href="lista.php?usuariocorrecto=<?php echo base64_encode($usuario); ?>">Volver a la lista</a>
    <form action="tiendas.php?usuariocorrecto=<?php echo base64_encode($usuario); ?>" method="post">
        <input type="text" name="nuevatienda" minlength="1" maxlength="30" required placeholder="Nueva tienda" autofocus>
        <input type="submit" value="Añadir">
    </form>

    <?php


    for ($i = 0; $i < $cantidadtiendas + $nuevo; $i++) {
        echo "<br>Tienda " . $i . ": " . $tiendas[$i];
    }

    file_put_contents("tienda_" . $usuario . ".txt", serialize($tiendas));
    ?>


</body>

</html>