<?php
/* 0=NO BISIESTO, 1=BISIESTO */
function bisiesto($ano)
{
    if ($ano % 4 == 0 && ($ano % 100 != 0 || $ano % 400 == 0)) {
        return 1;
    } else {
        return 0;
    }
}

/* 0=FECHA NO VALIDA, 1=FECHA VALIDA */
function fechavalida($dia, $mes, $ano)
{
    $fechavalida = 0;
    $diasmes = [0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    $diasmes[2] = $diasmes[2] + bisiesto($ano);
    if ($mes >= 1 && $mes <= 12 && $dia >= 1 && $dia <= $diasmes[$mes] && $ano >= 1) {
        $fechavalida = 1;
    }
    return ($fechavalida);
}

/* DEVUELVE TOTAL DE DIAS, O DEVUELVE -1 SI LA FECHA ES INCORRECTA */
function diasdesde111($dia, $mes, $ano)
{
    if (fechavalida($dia, $mes, $ano) == 1) {
        $diasmes = [0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        $diasmes[2] = $diasmes[2] + bisiesto($ano);
        $ano = $ano - 1;
        $totaldias = ($ano) * 365;
        $totaldias = $totaldias + (($ano - ($ano % 4)) / 4);
        $totaldias = $totaldias + (($ano - ($ano % 400)) / 400);
        $totaldias = $totaldias - (($ano - ($ano % 100)) / 100);
        for ($m = 1; $m < $mes; $m++) {
            $totaldias = $totaldias + $diasmes[$m];
        }
        $totaldias = $totaldias + ($dia - 1);
        return $totaldias;
    } else {
        return -1;
    }
}

/* DEVUELVE DE 1 A 7 (LUNES A DOMINGO), O DEVUELVE -1 SI LA FECHA ES INCORRECTA */
function diasemana($dia, $mes, $ano)
{
    if (fechavalida($dia, $mes, $ano) == 1) {
        $resto = (diasdesde111($dia, $mes, $ano) % 7) + 1;
        return $resto;
    } else {
        return -1;
    }
}

/* DEVUELVE LUNES A DOMINGO, O DEVUELVE -1 SI LA FECHA ES INCORRECTA */
function diasemanaletra($dia, $mes, $ano)
{
    if (fechavalida($dia, $mes, $ano) == 1) {
        $diasletra = ["lunes", "martes", "miercoles", "jueves", "viernes", "sabado", "domingo"];
        $dialetra = $diasletra[(diasemana($dia, $mes, $ano)) - 1];
        return $dialetra;
    } else {
        return -1;
    }
}

/* DEVUELVE EL MES EN LETRAS, O DEVUELVE -1 SI EL MES NO ES CORRECTO */
function mesletras($mes)
{
    if ($mes >= 1 && $mes <= 12) {
        $mesesletras = ["ENERO", "FEBRERO", "MARZO", "ABRIL", "MAYO", "JUNIO", "JULIO", "AGOSTO", "SEPTIEMBRE", "OCTUBRE", "NOVIEMBRE", "DICIEMBRE"];
        $mesletras = $mesesletras[$mes - 1];
        return $mesletras;
    } else {
        return -1;
    }
}

/* DEVUELVE EL CALENDARIO DEL MES SELECCIONADO */
function pintarmes($mes, $ano)
{
    if ($mes >= 1 && $mes <= 12 && $ano >= 1) {
        $dia = 1;

        /* CALCULAR EL DIA DE LA SEMANA */
        $restodias = (diasemana($dia, $mes, $ano) - 1);

        /* CALCULAR LOS DIAS QUE TIENE EL MES */
        $diasmes = [0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        $diasmes[2] = $diasmes[2] + bisiesto($ano);
        $diascalendario = $diasmes[$mes];

        $fin = 0;
        $contadordias = 1;
        $arraysemana = ["LUNES", "MARTES", "MIERCOLES", "JUEVES", "VIERNES", "SABADO", "DOMINGO"];

        echo "<br>" . mesletras($mes) . " de " . $ano;
        echo '<br><table border="1">';
        echo "<thead><tr>";
        for ($i = 0; $i <= 6; $i++) {
            echo "<th>" . $arraysemana[$i] . "</th>";
        }
        echo "</tr></thead>";
        echo "<tbody>";
        for ($fila = 0; $fin == 0; $fila++) {
            echo "<tr>";
            for ($columna = 0; $columna <= 6; $columna++, $contadordias++) {
                echo "<td>";
                if (($fila == 0 && $columna < $restodias)) {
                    echo "-";
                    $contadordias = 0;
                } else {
                    if ($contadordias <= $diascalendario) {
                        echo $contadordias;
                    } else {
                        echo "-";
                    }
                }
                if ($contadordias >= $diascalendario) {
                    $fin = 1;
                }
                echo "</td>";
            }
            echo "</tr>";
        }
        echo "</tbody>";
        echo "</table>";
    } else {
        return -1;
    }
}
